-- テーブル削除
DROP TABLE IF EXISTS customers;
DROP TABLE IF EXISTS products;
DROP TABLE IF EXISTS employees;
DROP TABLE IF EXISTS orders;
DROP TABLE IF EXISTS order_details;

-- 顧客テーブル
CREATE TABLE customers (
    customer_id INTEGER PRIMARY KEY,
    name TEXT,
    email TEXT,
    phone TEXT,
    address TEXT
);

-- 商品テーブル
CREATE TABLE products (
    product_id INTEGER PRIMARY KEY,
    name TEXT,
    category TEXT,
    price INTEGER
);

-- 従業員テーブル
CREATE TABLE employees (
    employee_id INTEGER PRIMARY KEY,
    name TEXT,
    department TEXT,
    age INTEGER
);

-- 注文テーブル
CREATE TABLE orders (
    order_id INTEGER PRIMARY KEY,
    customer_id INTEGER,
    employee_id INTEGER,
    order_date DATE
);

-- 注文明細テーブル
CREATE TABLE order_details (
    order_id INTEGER,
    product_id INTEGER,
    quantity INTEGER,
    PRIMARY KEY (order_id, product_id)
);

-- 顧客データ
INSERT INTO customers VALUES
(1, '佐藤 太郎', 'taro@example.com', '090-1111-2222', '東京都港区'),
(2, '鈴木 花子', NULL, '080-3333-4444', '大阪市中央区'),
(3, '高橋 健', 'ken@example.com', '070-5555-6666', '名古屋市中村区'),
(4, '田中 美咲', NULL, '090-7777-8888', '福岡市博多区'),
(5, '伊藤 誠', 'makoto@example.com', '080-9999-0000', '札幌市北区'),
(6, '山本 結衣', NULL, '070-1212-3434', '仙台市青葉区'),
(7, '田辺 涼子', NULL, '070-8989-6767', '横浜市鶴見区');

-- 商品データ
INSERT INTO products VALUES
(1, 'ノートPC A', 'ノートPC', 85000),
(2, 'ノートPC B', 'ノートPC', 92000),
(3, 'デスクトップPC C', NULL, 110000),
(4, 'ゲーミングPC D', 'ゲーミングPC', 180000),
(5, 'モニター 24インチ', '周辺機器', 20000),
(6, 'キーボード', NULL, 4000),
(7, 'マウス', '周辺機器', 3000),
(8, '外付けSSD 1TB', 'ストレージ', 13000),
(9, 'USBメモリ 64GB', 'ストレージ', 1500),
(10, 'プリンタ', '周辺機器', 15000),
(11, 'ゲーミングノートX', 'ゲーミングPC', 220000);

-- 従業員データ
INSERT INTO employees VALUES
(1, '青木 一郎', '営業', 43),
(2, '村上 美優', '営業', 31),
(3, '中村 翔', 'サポート', 31),
(4, '佐々木 彩', '事務', 27),
(5, '西村 亮太', '事務', 24);

-- 注文データ（15行）
INSERT INTO orders VALUES
  (1, 1, 1, '2025-06-01'),
  (2, 2, 2, '2025-06-02'),
  (3, 3, 1, '2025-06-03'),
  (4, 4, 3, '2025-06-04'),
  (5, 5, 1, '2025-06-05'),
  (6, 6, 4, '2025-06-06'),
  (7, 1, 2, '2025-06-07'),
  (8, 2, 1, '2025-06-08'),
  (9, 3, 3, '2025-06-09'),
  (10, 4, 1, '2025-06-10'),
  (11, 5, 2, '2025-06-11'),
  (12, 6, 1, '2025-06-12'),
  (13, 1, 3, '2025-06-13'),
  (14, 2, 4, '2025-06-14'),
  (15, 3, 2, '2025-06-15');

-- 注文明細データ（40行）
insert into order_details (order_id, product_id, quantity) values
  (1, 10, 3),
  (2, 1, 3),
  (2, 9, 3),
  (3, 5, 2),
  (3, 7, 2),
  (4, 2, 1),
  (4, 5, 4),
  (5, 6, 2),
  (5, 9, 1),
  (5, 10, 2),
  (6, 1, 1),
  (6, 3, 4),
  (6, 5, 3),
  (6, 7, 2),
  (7, 5, 4),
  (7, 8, 1),
  (7, 9, 4),
  (7, 10, 1),
  (8, 1, 4),
  (8, 5, 3),
  (8, 7, 3),
  (8, 8, 2),
  (9, 3, 1),
  (9, 5, 2),
  (9, 9, 4),
  (10, 3, 1),
  (10, 5, 1),
  (10, 7, 4),
  (10, 9, 1),
  (11, 5, 1),
  (11, 7, 4),
  (12, 4, 1),
  (12, 5, 2),
  (12, 8, 4),
  (12, 9, 4),
  (12, 10, 3),
  (13, 4, 3),
  (13, 6, 3),
  (14, 9, 4),
  (15, 9, 4);
